import machine, time
from machine import Pin, I2C
 
import ssd1306

class HCSR04:
    def __init__(self, trigger_pin, echo_pin, echo_timeout_us=500*2*30):
        self.echo_timeout_us = echo_timeout_us
        # Init trigger pin (out)
        self.trigger = Pin(trigger_pin, mode=Pin.OUT, pull=None)
        self.trigger.value(0)
        # Init echo pin (in)
        self.echo = Pin(echo_pin, mode=Pin.IN, pull=None)

    def _send_pulse_and_wait(self):
        self.trigger.value(0) # Stabilize the sensor
        time.sleep_us(5)
        self.trigger.value(1)
        # Send a 10us pulse.
        time.sleep_us(10)
        self.trigger.value(0)
        try:
            pulse_time = machine.time_pulse_us(self.echo, 1, self.echo_timeout_us)
            return pulse_time
        except OSError as ex:
            if ex.args[0] == 110: # 110 = ETIMEDOUT
                raise OSError('Out of range')
            raise ex

    def distance_mm(self):
        pulse_time = self._send_pulse_and_wait()
        mm = pulse_time * 100 // 582
        return mm

    def distance_cm(self):
        pulse_time = self._send_pulse_and_wait()
        cms = (pulse_time / 2) / 29.1
        return cms
i2c = I2C(scl=Pin(14), sda=Pin(12))
oled = ssd1306.SSD1306_I2C(128,64,i2c)
oled.fill(0)
c=0
sensor = HCSR04(trigger_pin=2, echo_pin=4, echo_timeout_us=10000)
while True:
    if c==21:
        T2=time.time()#time.ticks_ms()
        To=(T2-T1)/10
        F=1/To
        
        a = str(To)
        b = str(F)
        c=0
        print(To)
        oled.text(a,40, 0, 1)
        oled.text(b,40, 12, 1)
        oled.show()
    else:
        distance = sensor.distance_cm()
        print (distance)
        
        if distance<10:
            c=c+1
        if c==1:
            T1=time.time()#time.tcks_ms()
            
    time.sleep(0.2)
        
        
   
    
    
    
    
    
    
    
    
    
    
