from machine import I2C
from machine import Pin
import time
import mpu6050

try:
  import usocket as socket
except:
  import socket

import network

import esp
esp.osdebug(None)

import gc
gc.collect()

ssid = 'Przyspieszenie_ST3AM'
password = '123456789'

ap = network.WLAN(network.AP_IF)
ap.active(True)
ap.config(essid=ssid, password=password)

d = Pin(2, Pin.OUT) #deklarowanie diody

i2c = I2C(scl=Pin(5), sda=Pin(4))       #initializing the I2C method for ESP8266
mpu= mpu6050.accel(i2c)

while ap.active() == False:
    pass

print('Connection successful')
print(ap.ifconfig())

def web_page():
    html0 = """<html><head><meta name="viewport" content="width=device-width, initial-scale=1.2"></head>
    <body><style> td { border: 1px solid black; } </style><table>
    <tr>
    <td>Czas</td> <td>Przyspieszenie</td>
    </tr>"""
    html1 = """<tr>
      <td>"""
    html2 = """</td> <td>"""
    html3 = """</td>
   </tr>"""
    html4 = """</table></body></html>"""
    
    html = html0;
    for i in range (0,17):
        html = html + html1 + str(0.5*i) + html2 + str(ACX[i+1]) + html3;
    html = html + html4;
    return html

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.bind(('', 80))
s.listen(5)

for i in range (1,10):   #mruganie diody na początku
    d.value(0)
    time.sleep(0.3)
    d.value(1)
    time.sleep(0.7)
    
ACX = [0];
d.value(0)    
for i in range (1,18):
    AcX=0;
    for i in range(9):         #uśrednenie wartości pomiarów
        AcX=AcX+mpu.get_AcX();
        time.sleep(0.05)
    AcX=AcX/10;
    AcX=-(AcX-379)/1500;  #skalowanie czujnika
    ACX.append(AcX)
d.value(1)

conn, addr = s.accept()
print('Got a connection from %s' % str(addr))
request = conn.recv(1024)
print('Content = %s' % str(request))
response = web_page()
conn.send(response)